﻿using VA.TMP.Integration.VIMT.Shared;
using VA.TMP.Integration.VIMT.VideoVisit.StateObject;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.VideoVisit.PipelineSteps.Delete
{
    /// <summary>
    /// Connect to CRM step.
    /// </summary>
    public class ConnectToCrmStep : FilterBase<VideoVisitDeleteStateObject>
    {
        /// <summary>
        /// Execute the step.
        /// </summary>
        /// <param name="state">State object.</param>
        public override void Execute(VideoVisitDeleteStateObject state)
        {
            state.OrganizationServiceProxy = PipelineUtilities.ConnectToCrm(state.OrganizationName, PipelineUtilities.CrmAuthenticationMode.Ad);
        }
    }
}